@ECHO OFF
TITLE XM6 Pro-68k
SETLOCAL


:: Setup


:: It is critical to update the version number before new scripts are published!
SET INTERNAL_VERSION=220123

SET SITE_URL=http://mijet.eludevisibility.org
SET BASE_URL=http://mijet.eludevisibility.org/XM6%%20Pro-68k

SET RESULT=
SET TEMP_FILE=
SET ERRORLEVEL=
SET URL=
SET URL_AFFIX=

CD/D "%~dp0.."

:: Need to use relative paths for GPG in case of character encoding problems
SET HOME=Scripts\GPG
SET VERIFY="%~dp0GPG\Verify.bat"
SET CURL="%~dp0curl\curl.exe"
SET SZIP_REL=7z\7za.exe
SET SZIP="%~dp0%SZIP_REL%"
SET SZIP_REL=Scripts\%SZIP_REL%

SET TEMP_BATCH=Temp.bat
DEL/F %TEMP_BATCH% 2>NUL 1>NUL

SET DL=%CURL% -# -f -k -L --limit-rate 500K
IF DEFINED TEST_MODE SET DL=CALL :FAKE_DL

:: Assume 'yes', disable output and progress (error messages will still print)
SET SZIP_ARGS=-y -bso0 -bsp0

:: Check installation

IF NOT EXIST %CURL%     GOTO INSTALL_ERROR
IF NOT EXIST %SZIP%     GOTO INSTALL_ERROR
IF NOT EXIST %SZIP_REL% GOTO INSTALL_ERROR
IF NOT EXIST %VERIFY%   GOTO INSTALL_ERROR

:: Interpret arguments / options

IF NOT DEFINED TEST_MODE CALL :DISCLAIMER

IF /I "%1"=="NOTES" GOTO UPDATE_NOTES


:: Start by checking for script updates


SET ARC=Scripts.7z

ECHO Checking for infrastructure updates...
ECHO.

:: No version file for this one; use internal version number (defined earlier)
CALL :CHECK_VERSION "" %ARC%.ver
IF ERRORLEVEL 1 GOTO ERROR

IF DEFINED TEST_MODE (
ECHO %INTERNAL_VERSION%
ECHO %VER2%
ECHO.
)

IF %INTERNAL_VERSION% GEQ %VER2% GOTO NO_SCRIPTS_UPDATE

:: The URL is the same as the archive name since there are no escape sequences
CALL :DOWNLOAD_VERIFY_EXTRACT %ARC% %ARC% "NO EXTRACT"
IF ERRORLEVEL 1 GOTO ERROR

:: Use a temporary batch file so we can self-update safely

DEL/F %TEMP_BATCH% 2>NUL 1>NUL
IF EXIST %TEMP_BATCH% (
ECHO Unable to remove temporary batch file. Permissions problem?
GOTO ERROR
)

:: Create a temporary file to handle the extraction since we may get overwritten

 >%TEMP_BATCH% ECHO @ECHO OFF
>>%TEMP_BATCH% ECHO IF NOT EXIST %SZIP_REL% GOTO ERROR
>>%TEMP_BATCH% ECHO %SZIP_REL% x %SZIP_ARGS% %ARC%
>>%TEMP_BATCH% ECHO IF ERRORLEVEL 1 GOTO ERROR
>>%TEMP_BATCH% ECHO DEL/F %ARC%
>>%TEMP_BATCH% ECHO ECHO Infrastructure updated. We will now restart the update.
>>%TEMP_BATCH% ECHO ECHO.
>>%TEMP_BATCH% ECHO ECHO NOTE: If this keeps happening, it's an infinite loop.^
 If that's the case,
>>%TEMP_BATCH% ECHO ECHO wait a few days and try again.^
 Hopefully the problem will be fixed soon.
>>%TEMP_BATCH% ECHO ECHO.
>>%TEMP_BATCH% ECHO PAUSE
>>%TEMP_BATCH% ECHO "Scripts\Check for Updates.bat"
>>%TEMP_BATCH% ECHO :ERROR
>>%TEMP_BATCH% ECHO ECHO.
>>%TEMP_BATCH% ECHO ECHO Infrastructure update failed!
>>%TEMP_BATCH% ECHO ECHO.
>>%TEMP_BATCH% ECHO PAUSE
>>%TEMP_BATCH% ECHO EXIT/B 1

:: Execute it

IF EXIST %TEMP_BATCH% %TEMP_BATCH%
ECHO Unable to create temporary batch file. Permissions problem?
GOTO ERROR

:NO_SCRIPTS_UPDATE


:: Check if the DLL Package needs to be updated


:: Check for the update flag and delete it; fail if it couldn't be deleted.
IF NOT EXIST "DLL Package Needs Updating" GOTO NO_DLL_UPDATE

:: This ensures that the DLL Package won't be redownloaded on every update.
:: (If we got this far then downloads should be working generally.)
DEL /F   "DLL Package Needs Updating" 2>NUL 1>NUL
IF EXIST "DLL Package Needs Updating" GOTO ERROR

:: Send the quit signal to XM6 in case the DLL files are in use.
IF EXIST XM6.EXE (
START/B "XM6 Pro-68k" .\XM6.EXE /Quit 2>NUL 1>NUL
ECHO.
ECHO The DLL Package needs to be updated.
ECHO.
ECHO Please ensure that XM6 is not running before continuing.
ECHO.
PAUSE
CLS
)

:: This does the rest. (Any existing files should be overwritable.)
GOTO INITIAL_INSTALL

:NO_DLL_UPDATE


:: Update or install XM6 Pro-68k


IF EXIST Version.txt GOTO UPDATE_CHECK

:INITIAL_INSTALL

SET URL=XM6%%20Pro-68k%%20DLL%%20Package.7z
CALL :DOWNLOAD_VERIFY_EXTRACT "XM6 Pro-68k DLL Package.7z"
IF ERRORLEVEL 1 GOTO ERROR
GOTO DOWNLOAD_AND_INSTALL

:UPDATE_CHECK

ECHO Checking for an update to XM6 Pro-68k...
ECHO.

CALL :CHECK_VERSION Version.txt Version.txt
IF ERRORLEVEL 1 GOTO ERROR

IF %VER1% GEQ %VER2% (
ECHO No update to XM6 Pro-68k is available at this time.
:: Might as well check for an update to the notes, if present
IF EXIST "Software Notes.txt" GOTO UPDATE_NOTES
GOTO EXIT
)

ECHO An update is available!
ECHO.
ECHO Your version: %VER1%   
ECHO New  version: %VER2%
ECHO.
CALL :ASK Yes "Do you want to download and install it?"
IF %ERRORLEVEL% EQU 0 GOTO EXIT

:DOWNLOAD_AND_INSTALL

IF NOT EXIST XM6.EXE GOTO NO_EXE

:: Send the quit signal to XM6
START/B "XM6 Pro-68k" .\XM6.EXE /Quit 2>NUL 1>NUL
:: This part is mostly just to give XM6 a chance to terminate before continuing
ECHO.
ECHO We will now attempt to back up XM6.exe and then download the new version.
ECHO.
ECHO Please ensure that XM6 is not running before continuing.
ECHO.
PAUSE
CLS

:: Make sure an old version of the executable is not in the way

IF EXIST XM6-OLD.EXE DEL/F XM6-OLD.EXE 2>NUL 1>NUL
IF EXIST XM6-OLD.EXE (
ECHO Unable to remove old backup file XM6-Old.exe
GOTO ERROR
)
:: NOTE: This MIGHT succeed even if the program is still running! Not a problem.
IF EXIST XM6.EXE RENAME XM6.EXE XM6-Old.exe 2>NUL 1>NUL
IF EXIST XM6.EXE (
ECHO Unable to back up existing file XM6.exe
ECHO.
ECHO Most likely this is because XM6 is running and the quit signal failed.
ECHO We cannot update while XM6 is running. Quit XM6 and then we will try again.
ECHO.
PAUSE
RENAME XM6.EXE XM6-Old.exe
ECHO.
)
IF EXIST XM6.EXE (
ECHO Unable to back up existing file XM6.exe on the second attempt.
ECHO.
ECHO If XM6 was not running then it could be a permissions problem.
ECHO Please reboot and try again, or attempt a manual installation.
GOTO ERROR
)
:NO_EXE

:: Download XM6

SET URL=XM6%%20Pro-68k.7z
CALL :DOWNLOAD_VERIFY_EXTRACT "XM6 Pro-68k.7z"
IF ERRORLEVEL 1 GOTO ERROR

ECHO Installation succeeded! XM6 will now be launched.
ECHO.
CALL :CLEANUP
PAUSE
START/B "XM6 Pro-68k" .\XM6.EXE
EXIT/B


:: End of script


:EXIT
CALL :CLEANUP
ECHO.
ECHO This script will now exit.
ECHO.
PAUSE
EXIT/B

:CLEANUP
DEL/F %TEMP_FILE%  2>NUL 1>NUL
DEL/F %TEMP_BATCH% 2>NUL 1>NUL
EXIT/B


:UPDATE_NOTES

SET ARC=Notes.7z

ECHO.
ECHO Checking for an update to the notes...
ECHO.

CALL :CHECK_VERSION "Software Notes.ver" %ARC%.ver
IF ERRORLEVEL 1 GOTO ERROR

IF %VER1% GEQ %VER2% (
ECHO No update to the notes is available at this time.
GOTO EXIT
)

CALL :DOWNLOAD_VERIFY_EXTRACT %ARC% %ARC%
IF ERRORLEVEL 1 GOTO ERROR

GOTO EXIT


:: Error handlers


:INSTALL_ERROR
ECHO.
ECHO Unable to find one or more critical files at the expected location.
ECHO.
ECHO Please try downloading a fresh copy of this package.
:ERROR
ECHO.
ECHO A fatal error has occurred.
GOTO EXIT


:: Subroutines


:DISCLAIMER
CLS
ECHO One or more files from the following site will be retrieved:
ECHO.
ECHO %SITE_URL%
ECHO.
ECHO No information will be transferred to the server other than basic protocols
ECHO needed for downloading files via an HTTP connection.
ECHO.
ECHO If you do not wish to connect to the above site, please close this window.
ECHO.
PAUSE
CLS
EXIT/B


:GET_SIZE
SET %1=%~z2
IF NOT DEFINED %1 SET %1=0
EXIT/B


:ASK
SET DEF=%1
SET DISPLAY=%~2 [%DEF%] 
:RETRY
SET YN=
SET YN=%DEF%
SET/P YN=%DISPLAY%
:: Treat a single space followed by return/enter as the default selection
IF /I  "%YN%"==" " SET YN=%DEF%
IF NOT "%YN%"=="" (
SET YN=%YN:~0,1%
) ELSE SET YN=%DEF%
IF /I "%YN%"=="Q" EXIT
IF /I "%YN%"=="Y" GOTO VALID
IF /I "%YN%"=="N" GOTO VALID
ECHO.
ECHO Please enter yes or no (or the first letter of either) or q to quit.
ECHO A blank response will be interpreted as the default, which is "%DEF%" here.
ECHO.
:: Pause to give the user a chance to ^C instead. ^C doesn't work at the prompt.
PAUSE
ECHO.
GOTO RETRY
:VALID
IF /I "%YN%"=="Y" EXIT/B 1
EXIT/B 0


:FAKE_DL
COPY "Test Files\%~nx2" "%~f2" >NUL
EXIT/B %ERRORLEVEL%


:DOWNLOAD

IF NOT "%2"=="" (
SET URL=%2
SET URL_AFFIX=
)

SET FINAL_URL=%BASE_URL%/%URL%%URL_AFFIX%
SET URL_AFFIX=

DEL/F "%~f1" 2>NUL 1>NUL
IF EXIST "%~f1" GOTO DOWNLOAD_EXISTS

%DL% -o "%~f1" --url %FINAL_URL%
SET RESULT=%ERRORLEVEL%

ECHO.
IF %RESULT% EQU 0 EXIT/B 0
ECHO Unable to retrieve the file at the following URL:
ECHO.
ECHO %FINAL_URL%
ECHO.
ECHO Error code: %RESULT%
EXIT/B %RESULT%
:DOWNLOAD_EXISTS
ECHO Error: file already exists and wasn't able to be deleted!
ECHO.
ECHO File path: %~f1
EXIT/B 1


:: %1 Output file
:: %2 URL to retrieve or blank to use the URL variable (due to escape sequences)

:DOWNLOAD_VERIFY_EXTRACT

IF NOT "%2"=="" SET URL=%2

ECHO Downloading %1
ECHO.

SET URL_AFFIX=.sig
CALL :DOWNLOAD "%~1.sig"
IF ERRORLEVEL 1 EXIT/B %ERRORLEVEL%

CALL :DOWNLOAD "%~1"
IF ERRORLEVEL 1 EXIT/B %ERRORLEVEL%

:: NOTE: The archive will get deleted automatically if the signature check fails
CALL %VERIFY% "%~1"
IF ERRORLEVEL 1 EXIT/B %ERRORLEVEL%

IF /I "%~3"=="NO EXTRACT" (
DEL/F "%~1.sig" 2>NUL 1>NUL
EXIT/B 0
)

%SZIP% x %SZIP_ARGS% "%~1"
SET RESULT=%ERRORLEVEL%
DEL /F "%~1" "%~1.sig" 2>NUL 1>NUL
EXIT/B %RESULT%


:: %1 Name of local version file
:: %2 URL of server version file

:CHECK_VERSION

SET TEMP_FILE=Version.tmp

CALL :DOWNLOAD %TEMP_FILE% %2
IF ERRORLEVEL 1 EXIT/B %ERRORLEVEL%

CALL :GET_SIZE SIZE %TEMP_FILE%
IF %SIZE% NEQ 6 EXIT/B 1

SET   VER1=0
SET/P VER2=<%TEMP_FILE%
IF EXIST "%~1" SET/P VER1=<"%~1"

DEL/F %TEMP_FILE% 2>NUL 1>NUL
EXIT/B 0
